#ifndef PLAYERCONTROL_HPP
#define PLAYERCONTROL_HPP

#include "interfaces.hpp"

class PlayerControl:
    public IUiEvent,
    public IPlayerEvent
{
  public:
    PlayerControl(IPlayerInput *cntrl,
                  IUiInput *ui);
    ~PlayerControl();

    void playPause();
    void stop();

    void started();
    void stopped();
    void paused();

  private:
    IPlayerInput  *mCntrl;
    IUiInput      *mUi;

    typedef enum {
      STOP,
      PAUSE,
      PLAY
    } Status;

    Status  mStatus = STOP;
};

#endif // PLAYERCONTROL_HPP
